//////////////////////////////////////////////////
//                                              //
// IBAN-Tool (Windows-DLL Implementation)       //
// --------------------------------------       //
//                                              //
// The DLL IBANKernel.dll exports 4 Functions   // 
// for IBAN conversions.                        //
//                                              //
// IT_IBANVersion / IT_IBANVersionS             //
// returns version information about the DLL    //
//                                              //
// IT_IBANConvert / IT_IBANConvertS             //
// performs the actual conversion of a          //
// proprietary account number to its            //
// corresponding IBAN.                          //
//                                              //
//////////////////////////////////////////////////


//////////////////////////////////////////////////
//                                              //
// Functions with _cdecl declaration            //
// (VC++, C#, VB.NET, etc.)                     //
//                                              //
//////////////////////////////////////////////////
typedef int (__cdecl *IT_IBANVersion)      (DWORD *pdwMajor, 
                                            DWORD *pdwMinor, 
                                            char *pszValidUntil,	
                                            int  nValidLen);

typedef int (__cdecl *IT_IBANConvert)      (char *pszKonto, 
                                            char *pszBCPC, 
                                            char *pszIBAN, 
                                            int nIBANLen, 
                                            char *pszBC, 
                                            int nBCLen, 
                                            char *pszPC, 
                                            int nPCLen, 
                                            char *pszBIC, 
                                            int nBICLen); 		


//////////////////////////////////////////////////
//                                              //
// Functions with __stdcall declaration         //
// (VBA, VB6)                                   //
// please notice the trailing 'S' in            //
// function names.                               //
//                                              //
//////////////////////////////////////////////////
typedef int (__stdcall *IT_IBANVersionS)   (DWORD *pdwMajor, 
                                            DWORD *pdwMinor, 
                                            char *pszValidUntil,	
                                            int  nValidLen);

typedef int (__stdcall *IT_IBANConvertS)   (char *pszKonto, 
                                            char *pszBCPC, 
                                            char *pszIBAN, 
                                            int nIBANLen, 
                                            char *pszBC, 
                                            int nBCLen, 
                                            char *pszPC, 
                                            int nPCLen, 
                                            char *pszBIC, 
                                            int nBICLen); 		
